/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical.utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.module.chemical.ChemicalEnums;
import terrails.xnetgases.module.chemical.utils.GasHelper;
import terrails.xnetgases.module.chemical.utils.InfuseHelper;
import terrails.xnetgases.module.chemical.utils.PigmentHelper;
import terrails.xnetgases.module.chemical.utils.SlurryHelper;

public class ChemicalHelper {
    public static Optional<IChemicalHandler<?, ?>> handler(ICapabilityProvider provider, Direction direction, ChemicalEnums.Type type) {
        IChemicalHandler handler = null;
        switch (type) {
            case GAS: {
                Optional<IGasHandler> opt = GasHelper.handler(provider, direction);
                if (!opt.isPresent()) break;
                handler = (IChemicalHandler)opt.get();
                break;
            }
            case INFUSE: {
                Optional<IInfusionHandler> opt = InfuseHelper.handler(provider, direction);
                if (!opt.isPresent()) break;
                handler = (IChemicalHandler)opt.get();
                break;
            }
            case PIGMENT: {
                Optional<IPigmentHandler> opt = PigmentHelper.handler(provider, direction);
                if (!opt.isPresent()) break;
                handler = (IChemicalHandler)opt.get();
                break;
            }
            case SLURRY: {
                Optional<ISlurryHandler> opt = SlurryHelper.handler(provider, direction);
                if (!opt.isPresent()) break;
                handler = (IChemicalHandler)opt.get();
            }
        }
        return Optional.ofNullable(handler);
    }

    public static boolean handlerPresent(ICapabilityProvider provider, Direction direction) {
        for (ChemicalEnums.Type type : ChemicalEnums.Type.values()) {
            if (!ChemicalHelper.handler(provider, direction, type).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static ChemicalStack<?> insert(IChemicalHandler<?, ?> handler, ChemicalStack<?> stack, @Nullable Direction direction, Action action, ChemicalEnums.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalEnums.Type.GAS -> GasHelper.insert((IGasHandler)handler, (GasStack)stack, direction, action);
            case ChemicalEnums.Type.INFUSE -> InfuseHelper.insert((IInfusionHandler)handler, (InfusionStack)stack, direction, action);
            case ChemicalEnums.Type.PIGMENT -> PigmentHelper.insert((IPigmentHandler)handler, (PigmentStack)stack, direction, action);
            case ChemicalEnums.Type.SLURRY -> SlurryHelper.insert((ISlurryHandler)handler, (SlurryStack)stack, direction, action);
        };
    }

    @Nonnull
    public static ChemicalStack<?> extract(IChemicalHandler<?, ?> handler, long amount, @Nullable Direction direction, Action action, ChemicalEnums.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalEnums.Type.GAS -> GasHelper.extract((IGasHandler)handler, amount, direction, action);
            case ChemicalEnums.Type.INFUSE -> InfuseHelper.extract((IInfusionHandler)handler, amount, direction, action);
            case ChemicalEnums.Type.PIGMENT -> PigmentHelper.extract((IPigmentHandler)handler, amount, direction, action);
            case ChemicalEnums.Type.SLURRY -> SlurryHelper.extract((ISlurryHandler)handler, amount, direction, action);
        };
    }

    public static List<Chemical<?>> chemicalInTank(@Nonnull IChemicalHandler<?, ?> handler, @Nullable Direction direction, ChemicalEnums.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalEnums.Type.GAS -> GasHelper.chemicalInTank((IGasHandler)handler, direction).stream().map(chemical -> chemical).collect(Collectors.toList());
            case ChemicalEnums.Type.INFUSE -> InfuseHelper.chemicalInTank((IInfusionHandler)handler, direction).stream().map(chemical -> chemical).collect(Collectors.toList());
            case ChemicalEnums.Type.PIGMENT -> PigmentHelper.chemicalInTank((IPigmentHandler)handler, direction).stream().map(chemical -> chemical).collect(Collectors.toList());
            case ChemicalEnums.Type.SLURRY -> SlurryHelper.chemicalInTank((ISlurryHandler)handler, direction).stream().map(chemical -> chemical).collect(Collectors.toList());
        };
    }

    public static List<Chemical<?>> chemicalInTank(@Nonnull IChemicalHandler<?, ?> handler, ChemicalEnums.Type type) {
        return ChemicalHelper.chemicalInTank(handler, null, type);
    }

    public static long amountInTank(@Nonnull IChemicalHandler<?, ?> handler, @Nullable Direction direction, @Nullable Predicate<ChemicalStack<?>> filter, ChemicalEnums.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalEnums.Type.GAS -> GasHelper.amountInTank((IGasHandler)handler, direction, (GasStack stack) -> filter == null || filter.test((ChemicalStack<?>)stack));
            case ChemicalEnums.Type.INFUSE -> InfuseHelper.amountInTank((IInfusionHandler)handler, direction, (InfusionStack stack) -> filter == null || filter.test((ChemicalStack<?>)stack));
            case ChemicalEnums.Type.PIGMENT -> PigmentHelper.amountInTank((IPigmentHandler)handler, direction, (PigmentStack stack) -> filter == null || filter.test((ChemicalStack<?>)stack));
            case ChemicalEnums.Type.SLURRY -> SlurryHelper.amountInTank((ISlurryHandler)handler, direction, (SlurryStack stack) -> filter == null || filter.test((ChemicalStack<?>)stack));
        };
    }

    public static long amountInTank(@Nonnull IChemicalHandler<?, ?> handler, @Nullable Direction direction, @Nullable Chemical<?> filter, ChemicalEnums.Type type) {
        return ChemicalHelper.amountInTank(handler, direction, (ChemicalStack<?> stack) -> filter == null || stack.getType() == filter, type);
    }

    public static long amountInTank(@Nonnull IChemicalHandler<?, ?> handler, @Nullable Direction direction, @Nullable ChemicalStack<?> filter, ChemicalEnums.Type type) {
        return ChemicalHelper.amountInTank(handler, direction, (ChemicalStack<?> stack) -> filter == null || stack.getType() == filter.getType(), type);
    }

    public static long amountInTank(@Nonnull IChemicalHandler<?, ?> handler, @Nullable Direction direction, ChemicalEnums.Type type) {
        return ChemicalHelper.amountInTank(handler, direction, (Predicate)null, type);
    }

    public static long amountInTank(@Nonnull IChemicalHandler<?, ?> handler, ChemicalEnums.Type type) {
        return ChemicalHelper.amountInTank(handler, null, type);
    }

    public static ItemStack normalizeStack(ItemStack stack, ChemicalEnums.Type type) {
        if (stack == null || type == null) {
            return ItemStack.f_41583_;
        }
        if (!stack.m_41656_(MekanismBlocks.CREATIVE_CHEMICAL_TANK.getItemStack())) {
            Chemical chemical = null;
            switch (type) {
                case GAS: {
                    GasStack gas;
                    Optional opt = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
                    if (!opt.isPresent() || (gas = (GasStack)((IGasHandler)opt.get()).getChemicalInTank(0)).isEmpty()) break;
                    chemical = gas.getRaw();
                    break;
                }
                case INFUSE: {
                    InfusionStack infuse;
                    Optional opt = stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).resolve();
                    if (!opt.isPresent() || (infuse = (InfusionStack)((IInfusionHandler)opt.get()).getChemicalInTank(0)).isEmpty()) break;
                    chemical = infuse.getRaw();
                    break;
                }
                case PIGMENT: {
                    PigmentStack pigment;
                    Optional opt = stack.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).resolve();
                    if (!opt.isPresent() || (pigment = (PigmentStack)((IPigmentHandler)opt.get()).getChemicalInTank(0)).isEmpty()) break;
                    chemical = pigment.getRaw();
                    break;
                }
                case SLURRY: {
                    SlurryStack slurry;
                    Optional opt = stack.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY).resolve();
                    if (!opt.isPresent() || (slurry = (SlurryStack)((ISlurryHandler)opt.get()).getChemicalInTank(0)).isEmpty()) break;
                    chemical = slurry.getRaw();
                }
            }
            if (chemical != null) {
                stack = ChemicalUtil.getFullChemicalTank((ChemicalTankTier)ChemicalTankTier.CREATIVE, chemical);
            }
        }
        return stack;
    }
}

